// FunctionListDialog.cpp : implementation file
//

#include "stdafx.h"
#include "script.h"
#include "FunctionListDialog.h"
#include "utility.h"

#undef _DEBUG // EMP DIKEO

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFunctionListDialog dialog


CFunctionListDialog::CFunctionListDialog(CWnd* pParent /*=NULL*/)
#ifdef _WIN32_WCE_PSPC
	: CDialog(IDD_FUNCTIONDIALOG_PPC, pParent)
#else
	: CDialog(IDD_FUNCTIONDIALOG, pParent)
#endif
{
#ifdef _WIN32_WCE_PSPC
	IDD = IDD_FUNCTIONDIALOG_PPC;
#else
	IDD = IDD_FUNCTIONDIALOG;
#endif
	m_cstrButton.Empty();
	m_pEditView=0;
	m_bSorted=m_bCaseSensitive=false;
	m_acstrMatches.RemoveAll();
	m_bLineBeginningsOnly=false;
	//{{AFX_DATA_INIT(CFunctionListDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CFunctionListDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFunctionListDialog)
	DDX_Control(pDX, IDC_LISTSORTED, m_ListSorted);
	DDX_Control(pDX, IDOK, m_ActionButton);
	DDX_Control(pDX, IDC_LIST, m_ListBox);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFunctionListDialog, CDialog)
	//{{AFX_MSG_MAP(CFunctionListDialog)
	ON_LBN_DBLCLK(IDC_LIST, OnDblclkList)
	ON_LBN_DBLCLK(IDC_LISTSORTED, OnDblclkList)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFunctionListDialog message handlers

/**input conditions -
 m_pEditView should point to a valid Edit View which contains the script (required)
 m_cstrButton should contain the string for the action button (optional)
 m_bSorted indicates if the list should be sorted (optional - default false)
 m_acstrMatches should be populated with the string(s) to match (required)
 **/

BOOL CFunctionListDialog::OnInitDialog() 
{	
	CDialog::OnInitDialog();

	if(!m_cstrCaption.IsEmpty())
		SetWindowText(m_cstrCaption);

	//set the caption of the action button (if provided)
	if(!m_cstrButton.IsEmpty())
		m_ActionButton.SetWindowText((LPCTSTR)m_cstrButton);

	if(m_bSorted)
	{
		m_ListBox.ShowWindow(SW_HIDE);
		m_pList=&m_ListSorted;
	}
	else
	{
		m_ListSorted.ShowWindow(SW_HIDE);
		m_pList=&m_ListBox;
	}

	//fill the listbox
	//m_pList->SetColumnWidth(1000);
	m_pList->ResetContent();
	m_iSelectionCharPos=m_iSelectionLine=-1;
	
	//vc6fix 
	//hcursorOld=SetCursor(LoadCursor(NULL, IDC_WAIT));
	//hcursorOld=SetCursor((HICON)LoadImage(NULL, IDC_WAIT,IMAGE_ICON,0,0,LR_DEFAULTCOLOR));
	SetWaitCursor(true);
	if(!doFillListBoxWithLinesContaining(m_pList,m_pEditView,&m_acstrMatches,m_bCaseSensitive,m_bLineBeginningsOnly))
	{
		MessageBeep(MB_ICONQUESTION);
		EndDialog(IDCANCEL);
	}
	SetWaitCursor(false);
	//SetCursor(hcursorOld);

	m_ListBox.SetFocus();
	return false;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFunctionListDialog::OnDblclkList() 
{
	// TODO: Add your control notification handler code here
	CFunctionListDialog::OnOK();
}

void CFunctionListDialog::OnOK() 
{
	int iSelection=m_pList->GetCurSel();
	CEdit& doc=m_pEditView->GetEditCtrl();

	// TODO: Add extra validation here
	if(iSelection==LB_ERR)
	{
#ifdef _POCKET
      m_pList->ResetContent();
      CDialog::OnOK();
#else
		MessageBeep(MB_ICONQUESTION);
#endif
		return;
	}
	m_pList->GetText(iSelection,m_cstrSelection);
	m_iSelectionCharPos=m_pList->GetItemData(iSelection);
	m_iSelectionLine=doc.LineFromChar(m_iSelectionCharPos);
	m_pList->ResetContent();

	CDialog::OnOK();
}

int CFunctionListDialog::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if(!m_pEditView)
		return -1;
	// TODO: Add your specialized creation code here

	return 0;
}


